/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network.config;

import com.ibm.hwmca.base.settings.network.config.PortConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class NetworkApplicationConfig
implements Serializable {
    private static final String TRACE_MASKT = "XSETNCFT";
    private static final String TRACE_MASKF = "XSETNCFF";
    private static final String TRACE_MASKD = "XSETNCFD";
    private String applicationID;
    private boolean publicDefaultAllow = false;
    private boolean privateDefaultAllow = true;
    private ArrayList ports = new ArrayList();
    private transient ResourceBundle nameBundle = null;

    public NetworkApplicationConfig() {
    }

    public NetworkApplicationConfig(String applicationID, ArrayList ports, boolean publicDefaultAllow, boolean privateDefaultAllow) {
        this.setApplicationID(applicationID);
        this.ports = ports;
        this.setPublicDefaultAllow(publicDefaultAllow);
        this.setPrivateDefaultAllow(privateDefaultAllow);
    }

    public String getApplicationID() {
        return this.applicationID;
    }

    public void setApplicationID(String applicationID) {
        this.applicationID = applicationID;
    }

    public ArrayList getPorts() {
        return this.ports;
    }

    public PortConfig[] getPortsArray() {
        return this.ports.toArray(new PortConfig[this.ports.size()]);
    }

    public void addPort(PortConfig port) {
        this.ports.add(port);
    }

    public boolean isPublicDefaultAllow() {
        return this.publicDefaultAllow;
    }

    public void setPublicDefaultAllow(boolean publicDefaultAllow) {
        this.publicDefaultAllow = publicDefaultAllow;
    }

    public boolean isPrivateDefaultAllow() {
        return this.privateDefaultAllow;
    }

    public void setPrivateDefaultAllow(boolean privateDefaultAllow) {
        this.privateDefaultAllow = privateDefaultAllow;
    }

    public ResourceBundle getResourceBundle() {
        return this.nameBundle;
    }

    public void setResourceBundle(ResourceBundle nameBundle) {
        this.nameBundle = nameBundle;
    }

    public String getName() {
        String name = this.applicationID;
        if (this.nameBundle != null) {
            try {
                name = this.nameBundle.getString(this.getApplicationID());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.applicationID);
        sb.append(" ports(");
        if (this.ports != null) {
            for (int idx = 0; idx < this.ports.size(); ++idx) {
                if (idx != 0) {
                    sb.append(",");
                }
                sb.append('[');
                sb.append(this.ports.get(idx).toString());
                sb.append(']');
            }
        }
        sb.append(") ");
        sb.append("priv_dflt_allow(");
        sb.append(this.privateDefaultAllow);
        sb.append(") ");
        sb.append("pub_dflt_allow(");
        sb.append(this.publicDefaultAllow);
        sb.append(")");
        return sb.toString();
    }
}

